/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model.academia;

public class Query {
    private String query;

    private String augmentHistory(String query) {
        return String.format("%s&usehistory=y", query);
    }

    private String augmentJournal(String query, String journal) {
        if (journal.trim().isEmpty()) {
            return query;
        }
        return String.format("%s[journal]+AND+%s", journal.toLowerCase(), query);
    }

    private String augmentLimit(String query, String limit) {
        if (limit.trim().isEmpty()) {
            return query;
        }
        return String.format("%s&retmax=%s", query, limit);
    }

    private String augmentYear(String query, String year) {
        if (year.trim().isEmpty()) {
            return query;
        }
        return String.format("%s+AND+%s[pdat]", query, year);
    }

    public Query(String rawQuery) {
        rawQuery = rawQuery.replace(",", "");
        rawQuery = rawQuery.replace(" ", "+");
        this.query = this.augmentHistory(rawQuery);
    }

    public Query(String rawQuery, String journal, String year, String limit) {
        rawQuery = rawQuery.replace(" ", "+");
        rawQuery = this.augmentYear(rawQuery, year);
        rawQuery = this.augmentJournal(rawQuery, journal);
        rawQuery = this.augmentHistory(rawQuery);
        this.query = this.augmentLimit(rawQuery, limit);
    }

    public String toString() {
        return this.query;
    }
}

