/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.tasks;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.baderlab.csapps.socialnetwork.model.SocialNetworkAppManager;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.view.vizmap.mappings.BoundaryRangeValues;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.view.vizmap.mappings.DiscreteMapping;
import org.cytoscape.view.vizmap.mappings.PassthroughMapping;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class ApplyVisualStyleTask
extends AbstractTask {
    private VisualMappingManager vmmServiceRef;
    private VisualStyleFactory visualStyleFactoryServiceRef;
    private VisualMappingFunctionFactory passthroughMappingFactoryServiceRef;
    private VisualMappingFunctionFactory continuousMappingFactoryServiceRef;
    private VisualMappingFunctionFactory discreteMappingFactoryServiceRef;
    private VisualStyle incitesLiteVisualStyle;
    private VisualStyle pubmedLiteVisualStyle;
    private VisualStyle scopusLiteVisualStyle;
    private VisualStyle defaultVisualStyle;
    private TaskMonitor taskMonitor;
    SocialNetworkAppManager appManager = null;

    private TaskMonitor getTaskMonitor() {
        return this.taskMonitor;
    }

    private void setTaskMonitor(TaskMonitor taskMonitor) {
        this.taskMonitor = taskMonitor;
    }

    private VisualStyle getIncitesLiteVisualStyle() {
        if (this.incitesLiteVisualStyle == null) {
            this.incitesLiteVisualStyle = this.createIncitesLiteVisualStyle();
        }
        return this.incitesLiteVisualStyle;
    }

    private VisualStyle getPubmedLiteVisualStyle() {
        if (this.pubmedLiteVisualStyle == null) {
            this.pubmedLiteVisualStyle = this.createPubmedLiteVisualStyle();
        }
        return this.pubmedLiteVisualStyle;
    }

    private VisualStyle getScopusLiteVisualStyle() {
        if (this.scopusLiteVisualStyle == null) {
            this.scopusLiteVisualStyle = this.createScopusLiteVisualStyle();
        }
        return this.scopusLiteVisualStyle;
    }

    private VisualStyle getDefaultVisualStyle() {
        if (this.defaultVisualStyle == null) {
            this.defaultVisualStyle = this.visualStyleFactoryServiceRef.createVisualStyle("Default");
        }
        return this.defaultVisualStyle;
    }

    public ApplyVisualStyleTask(VisualStyleFactory visualStyleFactoryServiceRef, VisualMappingManager vmmServiceRef, VisualMappingFunctionFactory passthroughMappingFactoryServiceRef, VisualMappingFunctionFactory continuousMappingFactoryServiceRef, VisualMappingFunctionFactory discreteMappingFactoryServiceRef, SocialNetworkAppManager appManager) {
        this.vmmServiceRef = vmmServiceRef;
        this.visualStyleFactoryServiceRef = visualStyleFactoryServiceRef;
        this.passthroughMappingFactoryServiceRef = passthroughMappingFactoryServiceRef;
        this.discreteMappingFactoryServiceRef = discreteMappingFactoryServiceRef;
        this.continuousMappingFactoryServiceRef = continuousMappingFactoryServiceRef;
        this.appManager = appManager;
    }

    private VisualStyle addNodeLabels(VisualStyle visualStyle) {
        String colName = (String)this.appManager.getCurrentlySelectedSocialNetwork().getVisualStyleMap().get(BasicVisualLexicon.NODE_LABEL)[0];
        PassthroughMapping mapping = (PassthroughMapping)this.passthroughMappingFactoryServiceRef.createVisualMappingFunction(colName, Integer.class, BasicVisualLexicon.NODE_LABEL);
        visualStyle.addVisualMappingFunction((VisualMappingFunction)mapping);
        return visualStyle;
    }

    private VisualStyle addEdgeLabels(VisualStyle visualStyle) {
        String colName = (String)this.appManager.getCurrentlySelectedSocialNetwork().getVisualStyleMap().get(BasicVisualLexicon.EDGE_LABEL)[0];
        PassthroughMapping mapping = (PassthroughMapping)this.passthroughMappingFactoryServiceRef.createVisualMappingFunction(colName, Integer.class, BasicVisualLexicon.EDGE_LABEL);
        visualStyle.addVisualMappingFunction((VisualMappingFunction)mapping);
        return visualStyle;
    }

    private VisualStyle modifyEdgeWidth(VisualStyle visualStyle) {
        Object[] attributes = this.appManager.getCurrentlySelectedSocialNetwork().getVisualStyleMap().get(BasicVisualLexicon.EDGE_WIDTH);
        String colName = (String)attributes[0];
        ContinuousMapping mapping = (ContinuousMapping)this.continuousMappingFactoryServiceRef.createVisualMappingFunction(colName, Integer.class, BasicVisualLexicon.EDGE_WIDTH);
        BoundaryRangeValues bv0 = new BoundaryRangeValues((Object)1.0, (Object)1.0, (Object)1.0);
        BoundaryRangeValues bv1 = new BoundaryRangeValues((Object)10.0, (Object)10.0, (Object)10.0);
        int min = (Integer)attributes[1];
        int max = (Integer)attributes[2];
        mapping.addPoint((Object)min, bv0);
        mapping.addPoint((Object)max, bv1);
        visualStyle.addVisualMappingFunction((VisualMappingFunction)mapping);
        return visualStyle;
    }

    private VisualStyle modifyNodeSize(VisualStyle visualStyle) {
        Object[] attributes = this.appManager.getCurrentlySelectedSocialNetwork().getVisualStyleMap().get(BasicVisualLexicon.NODE_SIZE);
        String colName = (String)attributes[0];
        ContinuousMapping mapping = (ContinuousMapping)this.continuousMappingFactoryServiceRef.createVisualMappingFunction(colName, Integer.class, BasicVisualLexicon.NODE_SIZE);
        BoundaryRangeValues bv0 = new BoundaryRangeValues((Object)10.0, (Object)10.0, (Object)10.0);
        BoundaryRangeValues bv1 = new BoundaryRangeValues((Object)50.0, (Object)50.0, (Object)50.0);
        int min = (Integer)attributes[1];
        int max = (Integer)attributes[2];
        mapping.addPoint((Object)min, bv0);
        mapping.addPoint((Object)max, bv1);
        visualStyle.addVisualMappingFunction((VisualMappingFunction)mapping);
        return visualStyle;
    }

    private VisualStyle modifyNodeColor(VisualStyle visualStyle) {
        visualStyle.setDefaultValue(BasicVisualLexicon.NODE_FILL_COLOR, (Object)new Color(0, 204, 204));
        DiscreteMapping mapping = null;
        Object[] tempVar = this.appManager.getCurrentlySelectedSocialNetwork().getVisualStyleMap().get(BasicVisualLexicon.NODE_FILL_COLOR);
        Map colorMap = (Map)tempVar[0];
        for (Map.Entry colorMapEntry : colorMap.entrySet()) {
            String colName = (String)colorMapEntry.getKey();
            mapping = (DiscreteMapping)this.discreteMappingFactoryServiceRef.createVisualMappingFunction(colName, String.class, BasicVisualLexicon.NODE_FILL_COLOR);
            for (Map.Entry attrMapEntry : ((HashMap)colorMapEntry.getValue()).entrySet()) {
                mapping.putMapValue(attrMapEntry.getKey(), attrMapEntry.getValue());
            }
            visualStyle.addVisualMappingFunction((VisualMappingFunction)mapping);
        }
        return visualStyle;
    }

    private VisualStyle modifyNodeBorder(VisualStyle visualStyle) {
        DiscreteMapping mapping = null;
        Object[] tempVar = this.appManager.getCurrentlySelectedSocialNetwork().getVisualStyleMap().get(BasicVisualLexicon.NODE_BORDER_PAINT);
        Map colorMap = (Map)tempVar[0];
        for (Map.Entry colorMapEntry : colorMap.entrySet()) {
            String colName = (String)colorMapEntry.getKey();
            mapping = (DiscreteMapping)this.discreteMappingFactoryServiceRef.createVisualMappingFunction(colName, String.class, BasicVisualLexicon.NODE_BORDER_PAINT);
            for (Map.Entry attrMapEntry : ((HashMap)colorMapEntry.getValue()).entrySet()) {
                mapping.putMapValue(attrMapEntry.getKey(), attrMapEntry.getValue());
            }
            visualStyle.addVisualMappingFunction((VisualMappingFunction)mapping);
        }
        tempVar = this.appManager.getCurrentlySelectedSocialNetwork().getVisualStyleMap().get(BasicVisualLexicon.NODE_BORDER_WIDTH);
        Map sizeMap = (Map)tempVar[0];
        for (Map.Entry sizeMapEntry : sizeMap.entrySet()) {
            String colName = (String)sizeMapEntry.getKey();
            mapping = (DiscreteMapping)this.discreteMappingFactoryServiceRef.createVisualMappingFunction(colName, String.class, BasicVisualLexicon.NODE_BORDER_WIDTH);
            for (Map.Entry attrMapEntry : ((HashMap)sizeMapEntry.getValue()).entrySet()) {
                mapping.putMapValue(attrMapEntry.getKey(), attrMapEntry.getValue());
            }
            visualStyle.addVisualMappingFunction((VisualMappingFunction)mapping);
        }
        tempVar = this.appManager.getCurrentlySelectedSocialNetwork().getVisualStyleMap().get(BasicVisualLexicon.NODE_LABEL_FONT_FACE);
        Map fontMap = (Map)tempVar[0];
        for (Map.Entry fontMapEntry : fontMap.entrySet()) {
            String colName = (String)fontMapEntry.getKey();
            mapping = (DiscreteMapping)this.discreteMappingFactoryServiceRef.createVisualMappingFunction(colName, String.class, BasicVisualLexicon.NODE_LABEL_FONT_FACE);
            for (Map.Entry attrMapEntry : ((HashMap)fontMapEntry.getValue()).entrySet()) {
                mapping.putMapValue(attrMapEntry.getKey(), attrMapEntry.getValue());
            }
            visualStyle.addVisualMappingFunction((VisualMappingFunction)mapping);
        }
        return visualStyle;
    }

    private VisualStyle modifyNodeShape(VisualStyle visualStyle) {
        DiscreteMapping mapping = null;
        Object[] tempVar = this.appManager.getCurrentlySelectedSocialNetwork().getVisualStyleMap().get(BasicVisualLexicon.NODE_SHAPE);
        Map nodeShapeMap = (Map)tempVar[0];
        for (Map.Entry colorMapEntry : nodeShapeMap.entrySet()) {
            String colName = (String)colorMapEntry.getKey();
            mapping = (DiscreteMapping)this.discreteMappingFactoryServiceRef.createVisualMappingFunction(colName, String.class, BasicVisualLexicon.NODE_SHAPE);
            for (Map.Entry attrMapEntry : ((HashMap)colorMapEntry.getValue()).entrySet()) {
                mapping.putMapValue(attrMapEntry.getKey(), attrMapEntry.getValue());
            }
            visualStyle.addVisualMappingFunction((VisualMappingFunction)mapping);
        }
        return visualStyle;
    }

    private VisualStyle modifyEdgeOpacity(VisualStyle visualStyle) {
        String colName = (String)this.appManager.getCurrentlySelectedSocialNetwork().getVisualStyleMap().get(BasicVisualLexicon.EDGE_TRANSPARENCY)[0];
        ContinuousMapping mapping = (ContinuousMapping)this.continuousMappingFactoryServiceRef.createVisualMappingFunction(colName, Integer.class, BasicVisualLexicon.EDGE_TRANSPARENCY);
        Object[] attributes = this.appManager.getCurrentlySelectedSocialNetwork().getVisualStyleMap().get(BasicVisualLexicon.EDGE_WIDTH);
        BoundaryRangeValues bv0 = new BoundaryRangeValues((Object)100.0, (Object)100.0, (Object)100.0);
        BoundaryRangeValues bv1 = new BoundaryRangeValues((Object)300.0, (Object)300.0, (Object)300.0);
        Integer min = (Integer)attributes[1];
        Integer max = (Integer)attributes[2];
        mapping.addPoint((Object)1, bv0);
        mapping.addPoint((Object)(max / 2), bv1);
        visualStyle.addVisualMappingFunction((VisualMappingFunction)mapping);
        return visualStyle;
    }

    private VisualStyle createIncitesLiteVisualStyle() {
        VisualStyle incitesLiteVisualStyle = this.visualStyleFactoryServiceRef.createVisualStyle("Incites 'Lite'");
        this.addNodeLabels(incitesLiteVisualStyle);
        this.modifyEdgeWidth(incitesLiteVisualStyle);
        this.modifyNodeSize(incitesLiteVisualStyle);
        this.modifyEdgeOpacity(incitesLiteVisualStyle);
        this.modifyNodeColor(incitesLiteVisualStyle);
        this.modifyNodeBorder(incitesLiteVisualStyle);
        this.modifyNodeShape(incitesLiteVisualStyle);
        return incitesLiteVisualStyle;
    }

    private VisualStyle createPubmedLiteVisualStyle() {
        VisualStyle pubmedLiteVisualStyle = this.visualStyleFactoryServiceRef.createVisualStyle("Pubmed 'Lite'");
        this.addNodeLabels(pubmedLiteVisualStyle);
        this.modifyNodeSize(pubmedLiteVisualStyle);
        this.modifyEdgeWidth(pubmedLiteVisualStyle);
        this.modifyEdgeOpacity(pubmedLiteVisualStyle);
        return pubmedLiteVisualStyle;
    }

    private VisualStyle createScopusLiteVisualStyle() {
        VisualStyle scopusLiteVisualStyle = this.visualStyleFactoryServiceRef.createVisualStyle("Scopus 'Lite'");
        this.addNodeLabels(scopusLiteVisualStyle);
        this.modifyNodeSize(scopusLiteVisualStyle);
        this.modifyEdgeWidth(scopusLiteVisualStyle);
        this.modifyEdgeOpacity(scopusLiteVisualStyle);
        return scopusLiteVisualStyle;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.setTaskMonitor(taskMonitor);
        switch (this.appManager.getVisualStyleID()) {
            case -1: {
                this.vmmServiceRef.setCurrentVisualStyle(this.getDefaultVisualStyle());
                break;
            }
            case -103: {
                this.getTaskMonitor().setTitle("Loading Incites Lite Visual Style ... ");
                this.getTaskMonitor().setProgress(0.0);
                this.getTaskMonitor().setStatusMessage("");
                this.vmmServiceRef.setCurrentVisualStyle(this.getIncitesLiteVisualStyle());
                break;
            }
            case -100: {
                this.getTaskMonitor().setTitle("Loading Pubmed Lite Visual Style ... ");
                this.getTaskMonitor().setProgress(0.0);
                this.getTaskMonitor().setStatusMessage("");
                this.vmmServiceRef.setCurrentVisualStyle(this.getPubmedLiteVisualStyle());
                break;
            }
            case -101: {
                this.getTaskMonitor().setTitle("Loading Scopus Lite Visual Style ... ");
                this.getTaskMonitor().setProgress(0.0);
                this.getTaskMonitor().setStatusMessage("");
                this.vmmServiceRef.setCurrentVisualStyle(this.getScopusLiteVisualStyle());
            }
        }
    }
}

