/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.baderlab.csapps.socialnetwork.model.SocialNetwork;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicSocialNetworkVisualstyle {
    public static final String nodeattr_label = "Label";
    public static final String nodeattr_fname = "First Name";
    public static final String nodeattr_lname = "Last Name";
    public static final String nodeattr_pub = "Publications";
    public static final String nodeattr_numpub = "# of Publications";
    public static final String edgeattr_numcopubs = "# of copubs";
    public static final String nodeattr_timescited = "Times Cited";
    public static final String networkattr_totalPub = "Total Publications";
    private CyNetwork network;
    private SocialNetwork socialNetwork;

    public void applyVisualStyle(CyNetwork network, SocialNetwork socialNetwork) {
        this.network = network;
        this.socialNetwork = socialNetwork;
        this.applyNodeStyle(this.network, this.socialNetwork);
        this.applyEdgeStyle(this.network, this.socialNetwork);
    }

    protected void applyNodeStyle(CyNetwork network, SocialNetwork socialNetwork) {
        CyTable nodeTable = null;
        int minNodeSize = 0;
        int maxNodeSize = 0;
        socialNetwork.getVisualStyleMap().put(BasicVisualLexicon.NODE_LABEL, new Object[]{nodeattr_label});
        nodeTable = network.getDefaultNodeTable();
        CyColumn timesCitedColumn = nodeTable.getColumn(nodeattr_timescited);
        ArrayList timesCitedList = (ArrayList)timesCitedColumn.getValues(Integer.class);
        minNodeSize = this.getSmallestInCutoff(timesCitedList, 10.0);
        maxNodeSize = this.getLargestInCutoff(timesCitedList, 95.0);
        socialNetwork.getVisualStyleMap().put(BasicVisualLexicon.NODE_SIZE, new Object[]{nodeattr_timescited, minNodeSize + 1, maxNodeSize});
    }

    protected void applyEdgeStyle(CyNetwork network, SocialNetwork socialNetwork) {
        CyTable edgeTable = network.getDefaultEdgeTable();
        int minEdgeWidth = 0;
        int maxEdgeWidth = 0;
        edgeTable = network.getDefaultEdgeTable();
        CyColumn copubColumn = edgeTable.getColumn(edgeattr_numcopubs);
        ArrayList copubList = (ArrayList)copubColumn.getValues(Integer.class);
        copubList = (ArrayList)copubColumn.getValues(Integer.class);
        minEdgeWidth = this.getSmallestInCutoff(copubList, 5.0);
        maxEdgeWidth = this.getLargestInCutoff(copubList, 100.0);
        socialNetwork.getVisualStyleMap().put(BasicVisualLexicon.EDGE_WIDTH, new Object[]{edgeattr_numcopubs, minEdgeWidth + 1, maxEdgeWidth});
        socialNetwork.getVisualStyleMap().put(BasicVisualLexicon.EDGE_TRANSPARENCY, new Object[]{edgeattr_numcopubs});
    }

    protected int getSmallestInCutoff(ArrayList<Integer> list, Double cutoff) {
        Collections.sort(list);
        DescriptiveStatistics stats = new DescriptiveStatistics();
        for (int value : list) {
            stats.addValue((double)value);
        }
        Double percentile = stats.getPercentile(cutoff.doubleValue());
        for (int i = 0; i < list.size(); ++i) {
            if (!((double)list.get(i).intValue() >= percentile)) continue;
            return list.get(i);
        }
        return list.get(0);
    }

    protected int getLargestInCutoff(ArrayList<Integer> list, Double cutoff) {
        Collections.sort(list);
        DescriptiveStatistics stats = new DescriptiveStatistics();
        for (int value : list) {
            stats.addValue((double)value);
        }
        Double percentile = stats.getPercentile(cutoff.doubleValue());
        for (int i = list.size() - 1; i > -1; --i) {
            if (!((double)list.get(i).intValue() <= percentile)) continue;
            return list.get(i);
        }
        return list.get(list.size() - 1);
    }
}

