/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model;

import java.util.HashMap;
import java.util.Map;

public class VisualStyles {
    public static final int DEFAULT_VISUAL_STYLE = -99;
    public static final String DEFAULT_VISUAL_STYLE_HELP = "The default visual style is the base visual style. It makes use of no network attributes.";
    public static final int PUBMED_LITE_VISUAL_STYLE = -100;
    public static final String PUBMED_LITE_VISUAL_STYLE_HELP = "The Pubmed 'Lite' visual style is designed for Pubmed networks. Pubmed networks typically lack institution information. Thus, no color coding is present. However they do contain all the standard list of attributes found in Academia data-sets. Information on the total citation count and total co-publication count of each individual author is present and can be visualized via node-size and edge width respectively.";
    public static final int SCOPUS_LITE_VISUAL_STYLE = -101;
    public static final String SCOPUS_LITE_VISUAL_STYLE_HELP = "The Scopus 'Lite' visual style is designed for Scopus networks. Scopus networks typically lack institution information. Thus, no color coding is present. However they do contain all the standard list of attributes found in Academia data-sets. Information on the total citation count and total co-publication count of each individual author is present and can be visualized via node-size and edge width respectively.";
    public static final int INCITES_LITE_VISUAL_STYLE = -103;
    public static final String INCITES_LITE_VISUAL_STYLE_HELP = "The Incites 'Lite' visual style is designed for Incites networks. Incites networks are fully annotated. This means that in addition to the standard list of attributes typically found in Academia data-sets they also contain institution information. The Incites 'Lite' visual style works by matching institutions to their respective locations and color-coding them. Institutions for which no location has been found are classified as 'other' (purple). Location matching is determined by a local map and as such may or may not be adequate. To add an institution and it's associated location go to:<br> <b>Tools</b> - <b>Incites</b> - <b>Add institution</b>.";
    private Map<String, Integer> visualStyleMap = null;

    public int getVisualStyleID(String visualStyle) {
        if (this.visualStyleMap == null) {
            this.visualStyleMap = new HashMap<String, Integer>();
            this.visualStyleMap.put("--SELECT NETWORK VISUAL STYLE--", -1);
            this.visualStyleMap.put("Incites 'Lite'", -103);
            this.visualStyleMap.put("Pubmed 'Lite'", -100);
            this.visualStyleMap.put("Scopus 'Lite'", -100);
        }
        return this.visualStyleMap.get(visualStyle);
    }

    public String[] getVisualStyleList(int visualStyleSelectorType) {
        String[] visualStyleList = null;
        switch (visualStyleSelectorType) {
            case -99: {
                visualStyleList = new String[]{"--SELECT NETWORK VISUAL STYLE--"};
                break;
            }
            case -103: {
                visualStyleList = new String[]{"Incites 'Lite'"};
                break;
            }
            case -100: {
                visualStyleList = new String[]{"Pubmed 'Lite'"};
                break;
            }
            case -101: {
                visualStyleList = new String[]{"Scopus 'Lite'"};
            }
        }
        return visualStyleList;
    }
}

