/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model.academia;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.baderlab.csapps.socialnetwork.CytoscapeUtilities;
import org.baderlab.csapps.socialnetwork.model.academia.Author;
import org.baderlab.csapps.socialnetwork.model.academia.Publication;
import org.baderlab.csapps.socialnetwork.model.academia.Query;
import org.baderlab.csapps.socialnetwork.model.academia.Tag;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pubmed {
    private Author author = null;
    private String journal = null;
    private ArrayList<Author> pubAuthorList = new ArrayList();
    private String pubDate = null;
    private List<Publication> pubList = new ArrayList<Publication>();
    private String queryKey = null;
    private String retMax = null;
    private String retStart = null;
    private String timesCited = null;
    private String title = null;
    private String totalPubs = null;
    private String webEnv = null;

    public Pubmed(String searchTerm) {
        Query query = new Query(searchTerm);
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            String url = String.format("http://eutils.ncbi.nlm.nih.gov/entrez/eutils/esearch.fcgi?db=pubmed&term=%s", query);
            saxParser.parse(url, this.getSearchHandler());
            this.commitPubMedSearch();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            CytoscapeUtilities.notifyUser("Encountered temporary server issues. Please try again some other time.");
        }
        catch (SAXException e) {
            e.printStackTrace();
            CytoscapeUtilities.notifyUser("Encountered temporary server issues. Please try again some other time.");
        }
        catch (IOException e) {
            e.printStackTrace();
            CytoscapeUtilities.notifyUser("Unable to connect to PubMed. Please check your internet connection.");
        }
    }

    private void commitPubMedSearch() {
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            if (Integer.parseInt(this.totalPubs) <= 500) {
                Tag tag = new Tag(this.queryKey, this.webEnv, this.retStart, this.retMax);
                String url = String.format("http://eutils.ncbi.nlm.nih.gov/entrez/eutils/esummary.fcgi?db=pubmed%s", tag);
                saxParser.parse(url, this.getPublicationHandler());
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            CytoscapeUtilities.notifyUser("Encountered temporary server issues. Please try again some other time.");
        }
        catch (SAXException e) {
            e.printStackTrace();
            CytoscapeUtilities.notifyUser("Encountered temporary server issues. Please try again some other time.");
        }
        catch (IOException e) {
            e.printStackTrace();
            CytoscapeUtilities.notifyUser("Unable to connect to PubMed. Please check your internet connection.");
        }
    }

    public List<Publication> getListOfPublications() {
        return this.pubList;
    }

    private DefaultHandler getPublicationHandler() {
        DefaultHandler publicationHandler = new DefaultHandler(){
            boolean isPubDate = false;
            boolean isAuthor = false;
            boolean isTitle = false;
            boolean isJournal = false;
            boolean isTimesCited = false;

            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (this.contains(attributes, "Author")) {
                    this.isAuthor = true;
                }
                if (this.contains(attributes, "FullJournalName")) {
                    this.isJournal = true;
                }
                if (this.contains(attributes, "PubDate")) {
                    this.isPubDate = true;
                }
                if (this.contains(attributes, "Title")) {
                    this.isTitle = true;
                }
                if (this.contains(attributes, "PmcRefCount")) {
                    this.isTimesCited = true;
                }
            }

            public void characters(char[] ch, int start, int length) throws SAXException {
                if (this.isPubDate) {
                    Pubmed.this.pubDate = new String(ch, start, length);
                    this.isPubDate = false;
                }
                if (this.isAuthor) {
                    Pubmed.this.author = new Author(new String(ch, start, length), -2113004178);
                    if (!Pubmed.this.pubAuthorList.contains(Pubmed.this.author)) {
                        Pubmed.this.pubAuthorList.add(Pubmed.this.author);
                    }
                    this.isAuthor = false;
                }
                if (this.isJournal) {
                    Pubmed.this.journal = new String(ch, start, length);
                    this.isJournal = false;
                }
                if (this.isTitle) {
                    Pubmed.this.title = new String(ch, start, length);
                    this.isTitle = false;
                }
                if (this.isTimesCited) {
                    Pubmed.this.timesCited = new String(ch, start, length);
                    this.isTimesCited = false;
                }
            }

            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (qName.equalsIgnoreCase("DocSum")) {
                    Pubmed.this.pubList.add(new Publication(Pubmed.this.title, Pubmed.this.pubDate, Pubmed.this.journal, Pubmed.this.timesCited, null, Pubmed.this.pubAuthorList));
                    Pubmed.this.pubAuthorList.clear();
                }
            }

            public boolean contains(Attributes attributes, String text) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!attributes.getValue(i).equalsIgnoreCase(text)) continue;
                    return true;
                }
                return false;
            }
        };
        return publicationHandler;
    }

    private DefaultHandler getSearchHandler() throws SAXException, IOException, ParserConfigurationException {
        DefaultHandler searchHandler = new DefaultHandler(){
            boolean isQueryKey = false;
            boolean isWebEnv = false;
            boolean isTotalPubs = false;

            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (qName.equalsIgnoreCase("Count")) {
                    this.isTotalPubs = true;
                }
                if (qName.equalsIgnoreCase("QueryKey")) {
                    this.isQueryKey = true;
                }
                if (qName.equalsIgnoreCase("WebEnv")) {
                    this.isWebEnv = true;
                }
            }

            public void characters(char[] ch, int start, int length) throws SAXException {
                if (this.isTotalPubs) {
                    Pubmed.this.totalPubs = new String(ch, start, length);
                    this.isTotalPubs = false;
                }
                if (this.isQueryKey) {
                    Pubmed.this.queryKey = new String(ch, start, length);
                    this.isQueryKey = false;
                }
                if (this.isWebEnv) {
                    Pubmed.this.webEnv = new String(ch, start, length);
                    this.isWebEnv = false;
                }
            }

            public void endElement(String uri, String localName, String qName) throws SAXException {
            }
        };
        return searchHandler;
    }

    public int getTotalPubs() {
        return this.totalPubs != null ? Integer.parseInt(this.totalPubs) : -1;
    }
}

