/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model.academia.parsers.incites;

import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.baderlab.csapps.socialnetwork.model.academia.Author;
import org.baderlab.csapps.socialnetwork.model.academia.parsers.incites.IncitesParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FacultySheetHandler
extends DefaultHandler {
    private String cellContents = "";
    private String rowContents = "";
    private String cellID = "";
    private IncitesParser incitesParser = null;
    private SharedStringsTable sst = null;

    public FacultySheetHandler(SharedStringsTable sst, IncitesParser incitesParser) {
        this.sst = sst;
        this.incitesParser = incitesParser;
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (name.equals("row")) {
            this.rowContents = "";
        }
        if (name.equals("v")) {
            this.cellID = "";
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.cellID = this.cellID + new String(ch, start, length);
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if (name.equals("v")) {
            this.cellContents = new XSSFRichTextString(this.sst.getEntryAt(Integer.parseInt(this.cellID))).toString();
            this.rowContents = this.rowContents + this.incitesParser.parseFacultyName(this.cellContents.trim().toLowerCase()) + ";";
        }
        if (name.equals("row") && !this.rowContents.trim().isEmpty() && !this.rowContents.contains("department") && !this.rowContents.contains("first name")) {
            this.incitesParser.getFacultySet().add(new Author(this.rowContents, -2));
            this.incitesParser.setDepartmentName(this.cellContents);
            if (this.rowContents.split(";").length == 2) {
                this.incitesParser.setDepartmentName("not_specified");
            }
        }
    }
}

