/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model.academia.parsers.incites;

import java.util.List;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.baderlab.csapps.socialnetwork.model.academia.Author;
import org.baderlab.csapps.socialnetwork.model.academia.Publication;
import org.baderlab.csapps.socialnetwork.model.academia.parsers.incites.IncitesParser;
import org.baderlab.csapps.socialnetwork.model.academia.parsers.incites.UnableToParseAuthorException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PubSheetHandler
extends DefaultHandler {
    List<Author> coauthorList = null;
    private String[] columns = null;
    private String cellID = "";
    private String cellContents = "";
    private String rowContents = "";
    private IncitesParser incitesParser = null;
    private boolean isString = false;
    Publication pub;
    private SharedStringsTable sst = null;
    String title;
    String timesCited = null;
    String expectedCitations = "0.00";
    String year = null;
    String subjectArea = null;
    String authors = null;

    public PubSheetHandler(SharedStringsTable sst, IncitesParser incitesParser) {
        this.sst = sst;
        this.incitesParser = incitesParser;
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (name.equals("row")) {
            this.rowContents = "";
        }
        if (name.equals("c")) {
            if (attributes.getValue("t") != null) {
                this.isString = true;
            }
            this.cellID = "";
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.cellID = this.cellID + new String(ch, start, length);
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if (name.equals("v")) {
            if (this.isString) {
                this.cellContents = new XSSFRichTextString(this.sst.getEntryAt(Integer.parseInt(this.cellID))).toString();
                this.isString = false;
            } else {
                this.cellContents = this.cellID;
            }
            this.rowContents = this.rowContents + this.cellContents + "\t";
        }
        if (name.equals("row") && !this.rowContents.trim().isEmpty()) {
            this.columns = this.rowContents.split("\t");
            if (this.columns.length == 6 && !this.columns[0].equalsIgnoreCase("Times Cited")) {
                this.timesCited = this.columns[0].trim().isEmpty() ? "0" : this.columns[0].trim();
                this.expectedCitations = this.columns[1].trim().isEmpty() ? "0.00" : this.columns[1].trim();
                this.year = this.columns[2].trim().isEmpty() ? "0" : this.columns[2].trim();
                this.subjectArea = this.columns[3];
                this.authors = this.columns[4];
                this.title = this.columns[5];
                try {
                    this.coauthorList = this.incitesParser.parseAuthors(this.authors);
                    if (this.coauthorList.size() == 1) {
                        Author loneAuthor = this.coauthorList.get(0);
                        this.incitesParser.getLoneAuthorList().add(loneAuthor);
                        this.coauthorList.add(loneAuthor);
                    }
                }
                catch (UnableToParseAuthorException e) {
                    e.printStackTrace();
                    return;
                }
                this.pub = new Publication(this.title, this.year, this.subjectArea, this.timesCited, this.expectedCitations, this.coauthorList);
                this.incitesParser.getPubList().add(this.pub);
            } else if (this.columns.length == 5) {
                this.incitesParser.updateDefectiveRows();
                this.timesCited = this.columns[0].trim().isEmpty() ? "0" : this.columns[0].trim();
                this.expectedCitations = "0.00";
                this.year = this.columns[1].trim().isEmpty() ? "0" : this.columns[1].trim();
                this.subjectArea = this.columns[2];
                this.authors = this.columns[3];
                this.title = this.columns[4];
                try {
                    this.coauthorList = this.incitesParser.parseAuthors(this.authors);
                    if (this.coauthorList.size() == 1) {
                        Author loneAuthor = this.coauthorList.get(0);
                        this.incitesParser.getLoneAuthorList().add(loneAuthor);
                        this.coauthorList.add(loneAuthor);
                    }
                }
                catch (UnableToParseAuthorException e) {
                    e.printStackTrace();
                    return;
                }
                this.pub = new Publication(this.title, this.year, this.subjectArea, this.timesCited, this.expectedCitations, this.coauthorList);
                this.incitesParser.getPubList().add(this.pub);
            } else if (this.columns.length == 4) {
                this.incitesParser.updateDefectiveRows();
                this.timesCited = this.columns[0].trim().isEmpty() ? "0" : this.columns[0].trim();
                this.expectedCitations = "0.00";
                this.year = this.columns[1].trim().isEmpty() ? "0" : this.columns[1].trim();
                this.subjectArea = "N/A";
                this.authors = this.columns[2];
                this.title = this.columns[3];
                try {
                    this.coauthorList = this.incitesParser.parseAuthors(this.authors);
                    if (this.coauthorList.size() == 1) {
                        Author loneAuthor = this.coauthorList.get(0);
                        this.incitesParser.getLoneAuthorList().add(loneAuthor);
                        this.coauthorList.add(loneAuthor);
                    }
                }
                catch (UnableToParseAuthorException e) {
                    e.printStackTrace();
                    return;
                }
                this.pub = new Publication(this.title, this.year, this.subjectArea, this.timesCited, this.expectedCitations, this.coauthorList);
                this.incitesParser.getPubList().add(this.pub);
            } else {
                this.incitesParser.updateIgnoredRows();
            }
        }
    }
}

