/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.baderlab.csapps.socialnetwork.CytoscapeUtilities;
import org.baderlab.csapps.socialnetwork.model.SocialNetworkAppManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.util.swing.FileChooserFilter;
import org.cytoscape.util.swing.FileUtil;

public class AcademiaPanel {
    private JPanel academiaInfoPanelRef = null;
    private JTextField facultyTextFieldRef = new JTextField();
    private JTextField pathTextFieldRef = new JTextField();
    private JRadioButton incitesRadioButton = null;
    private JRadioButton scopusRadioButton = null;
    private File selectedFileRef = null;
    private SocialNetworkAppManager appManager = null;
    private FileUtil fileUtil = null;
    protected CySwingApplication cySwingAppRef = null;

    public AcademiaPanel(SocialNetworkAppManager appManager, FileUtil fileUtil, CySwingApplication cySwingAppRef) {
        this.appManager = appManager;
        this.fileUtil = fileUtil;
        this.cySwingAppRef = cySwingAppRef;
    }

    public JPanel createAcademiaInfoPanel() {
        JPanel academiaInfoPanel = new JPanel();
        academiaInfoPanel.setLayout(new BorderLayout());
        academiaInfoPanel.setName("Academia");
        academiaInfoPanel.setBorder(BorderFactory.createTitledBorder("Academia"));
        academiaInfoPanel.add((Component)this.createDatabaseInfoPanel(), "North");
        this.setAcademiaInfoPanelRef(academiaInfoPanel);
        return academiaInfoPanel;
    }

    public JPanel createDatabaseInfoPanel() {
        JPanel databaseInfoPanel = new JPanel();
        databaseInfoPanel.setBorder(BorderFactory.createTitledBorder("Database"));
        databaseInfoPanel.setLayout(new BoxLayout(databaseInfoPanel, 1));
        databaseInfoPanel.add(this.createDatabasePanel());
        databaseInfoPanel.add(this.createLoadDataPanel());
        databaseInfoPanel.add(this.createSpecifyNetworkNamePanel());
        JPanel buttonWrapper = new JPanel();
        buttonWrapper.add((Component)this.createNetworkButton(), "Center");
        databaseInfoPanel.add(buttonWrapper);
        return databaseInfoPanel;
    }

    public JPanel createDatabasePanel() {
        JPanel databasePanel = new JPanel();
        databasePanel.setBorder(BorderFactory.createTitledBorder("Select Database"));
        databasePanel.setLayout(new BoxLayout(databasePanel, 0));
        this.incitesRadioButton = new JRadioButton("Incites", true);
        this.incitesRadioButton.setFocusable(true);
        this.scopusRadioButton = new JRadioButton("Scopus", false);
        this.scopusRadioButton.setFocusable(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.incitesRadioButton);
        buttonGroup.add(this.scopusRadioButton);
        databasePanel.add(this.incitesRadioButton);
        databasePanel.add(this.scopusRadioButton);
        return databasePanel;
    }

    public JButton createLoadButton() {
        JButton loadButton = new JButton("...");
        loadButton.setToolTipText("Load Incites / Scopus data");
        loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                FileChooserFilter filter1 = new FileChooserFilter("text file", "txt");
                FileChooserFilter filter2 = new FileChooserFilter("excel spreadsheet(xls)", "xls");
                FileChooserFilter filter3 = new FileChooserFilter("excel spreadsheet(xlsx)", "xlsx");
                FileChooserFilter filter4 = new FileChooserFilter("excel spreadsheet(csv)", "csv");
                HashSet<FileChooserFilter> filters = new HashSet<FileChooserFilter>();
                filters.add(filter1);
                filters.add(filter2);
                filters.add(filter3);
                filters.add(filter4);
                File textFile = AcademiaPanel.this.fileUtil.getFile((Component)AcademiaPanel.this.cySwingAppRef.getJFrame(), "Data File Selection", 0, filters);
                AcademiaPanel.this.setDataFile(textFile);
                AcademiaPanel.this.getPathTextFieldRef().setText(textFile.getAbsolutePath());
                AcademiaPanel.this.getFacultyTextFieldRef().setText(AcademiaPanel.this.parseFileName(textFile.getAbsolutePath()));
            }
        });
        return loadButton;
    }

    public JPanel createLoadDataPanel() {
        JPanel loadDataPanel = new JPanel();
        loadDataPanel.setBorder(BorderFactory.createTitledBorder("Load File"));
        loadDataPanel.setLayout(new BoxLayout(loadDataPanel, 0));
        this.setLoadTextField(new JTextField());
        this.getPathTextFieldRef().setEditable(true);
        loadDataPanel.add(this.getPathTextFieldRef());
        loadDataPanel.add(this.createLoadButton());
        return loadDataPanel;
    }

    public JButton createNetworkButton() {
        JButton createNetworkButton = new JButton("Create Network");
        createNetworkButton.setToolTipText("Create network");
        createNetworkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (AcademiaPanel.this.incitesRadioButton.isSelected()) {
                    AcademiaPanel.this.appManager.setAnalysis_type(0);
                }
                if (AcademiaPanel.this.scopusRadioButton.isSelected()) {
                    AcademiaPanel.this.appManager.setAnalysis_type(1);
                }
                if (!AcademiaPanel.this.incitesRadioButton.isSelected() && !AcademiaPanel.this.scopusRadioButton.isSelected()) {
                    CytoscapeUtilities.notifyUser("Please select a database");
                } else if (AcademiaPanel.this.getSelectedFileRef() == null || AcademiaPanel.this.getFacultyTextFieldRef().getText() == null) {
                    CytoscapeUtilities.notifyUser("Please select a file and/or specify network name.");
                } else if (!AcademiaPanel.this.getSelectedFileRef().getAbsolutePath().trim().equalsIgnoreCase(AcademiaPanel.this.getPathTextFieldRef().getText().trim())) {
                    CytoscapeUtilities.notifyUser("Please select a file.");
                } else if (AcademiaPanel.this.getFacultyTextFieldRef().getText().trim().isEmpty()) {
                    CytoscapeUtilities.notifyUser("Please specify network name.");
                } else {
                    try {
                        AcademiaPanel.this.appManager.createNetwork(AcademiaPanel.this.getSelectedFileRef());
                    }
                    catch (FileNotFoundException e) {
                        CytoscapeUtilities.notifyUser(AcademiaPanel.this.getPathTextFieldRef().getText() + " does not exist");
                    }
                }
            }
        });
        return createNetworkButton;
    }

    public JPanel createSpecifyNetworkNamePanel() {
        JPanel specifyNetworkNamePanel = new JPanel();
        specifyNetworkNamePanel.setBorder(BorderFactory.createTitledBorder("Specify Network Name"));
        specifyNetworkNamePanel.setLayout(new BoxLayout(specifyNetworkNamePanel, 0));
        this.setFacultyTextFieldRef(new JTextField());
        this.getFacultyTextFieldRef().setEditable(true);
        specifyNetworkNamePanel.add(this.getFacultyTextFieldRef());
        return specifyNetworkNamePanel;
    }

    public JPanel getAcademiaInfoPanelRef() {
        return this.academiaInfoPanelRef;
    }

    public JTextField getFacultyTextFieldRef() {
        return this.facultyTextFieldRef;
    }

    public JTextField getPathTextFieldRef() {
        return this.pathTextFieldRef;
    }

    public File getSelectedFileRef() {
        return this.selectedFileRef;
    }

    public String parseFileName(String path) {
        Pattern pattern = Pattern.compile("([^\\\\/]+?)(\\.xlsx|\\.txt|\\.csv)$");
        Matcher matcher = pattern.matcher(path);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "N/A";
    }

    public void setAcademiaInfoPanelRef(JPanel academiaInfoPanelRef) {
        this.academiaInfoPanelRef = academiaInfoPanelRef;
    }

    public void setDataFile(File selectedFile) {
        this.selectedFileRef = selectedFile;
    }

    public void setFacultyTextFieldRef(JTextField facultyTextField) {
        this.facultyTextFieldRef = facultyTextField;
    }

    public void setLoadTextField(JTextField pathTextField) {
        this.pathTextFieldRef = pathTextField;
    }
}

